<?php defined('BASEPATH') OR exit('No direct script access allowed');


require_once APPPATH.'libraries/DaaS_REST_Controller.php';
require_once APPPATH.'models/attachment_disclosure.php';
	
class Disclosure extends DaaS_REST_Controller{
	
	function __construct() {
		parent::__construct();
		if (!$this->request->disclosure_api_authorized) { //authorize request
				$this->response( 'Access Denied. Use Not Authorized.', 403);
		}
	}
	
	
	public function audit_get() {
		$optional_fields = array('first','last','ssn','start','end');
		
		//set variables for each optional field
		foreach($optional_fields as $optional_field){
			$$optional_field = element($optional_field, $this->get(), null); //checks to see if $field is in $get - if not, sets to null
		}
		if($start && !is_numeric($start)){
			$this->invalid_fields[] = 'start';
		}
		if($end && !is_numeric($end)){
			$this->invalid_fields[] = 'end';
		}
		if($ssn && (!is_numeric($ssn) || strlen($ssn != 9))){
			$this->invalid_fields[] = 'ssn';
		}
		$this->respond_with_error_if_fields_are_invalid();
		
		$conditions = array('recipient != ' => '');
		if(isset($start)) $conditions['disclosed >='] = $start;
		if(isset($end)) $conditions['disclosed <='] = $end;
		foreach(array('first', 'last', 'ssn') as $field){
			if(isset($$field)) $conditions[$field] = $$field;
		}
		
		$disclosures = Attachment_disclosure::find($conditions);
		if(!is_array($disclosures)) $this->response('Failed to get disclosure log.', 500);
		
		foreach($disclosures as $key => $disclosure){
			$disclosures[$key] = $disclosure->values(array('recipient', 'first', 'last', 'disclosed', 'received', 'title', 'sent_to', 'received_from', 'username', 'facility', 'purpose', 'ssn', 'patient_id'));
		}
		
		//todo - would be much better to have disclosures within an array, to make it easier for end developers to pull out all the disclosures without the metadata
		$this->response($disclosures, 200);
	}
	
}